module My_RPG

  class My_Map < RPG::Map


    include DA_RMXP

    def initialize(width=1, height=-1)
      @tileset_id = 1
      @width = width
      @height = height
      @autoplay_bgm = false
      @bgm = nil # change
      @liste = {}
      @nom_type = nil
      @numero = -1
      @bgs = nil # change

      @autoplay_bgs = false

      @encounter_list = []
      @encounter_step = 30
      set_table(@width, @height)
      @events = {}

      @dm = {}

    end


    # DMK
    attr_accessor :liste
    attr_accessor :nom_type # hein ?
    attr_accessor :numero

    attr_accessor :panorama_name

    attr_reader   :total_instructions

    attr_accessor :dm


    def comparer(other)
      # acomp
      
      raise(DMKW_DMK_Diff.new("map.numero")) if @numero != other.numero
      
      return super
    end

    def clone
      map = My_Map.new(0, 0)
      map.numero = @numero
      for event in @events
        map.events.update({event[0] => event[1].clone})
      end
      #p map
      #gets
      return map
    end

    def delete_events
      @events = {}

    end
  
    def width=(w)
      resize(w, @height)
    end

    def height=(h)
      resize(@width, h)
    end

    def resize(w, h)
      @width = w
      @height = h
      set_table
    end
    
    def set_table(w=@width, h=@height)
      @data = Table.new(w, h, 3)
    end


    def to_rm03

      cont = str_sized(@nom_type)
      list = @liste.sort
  
  
      for element in list
        if element[0] != 91
          cont << to_128(element[0]) << str_sized(element[1])
        end
      end

      contenu = ""
      i = 0
      for event in @events.sort
        contenu << event[1].to_rm03
        i += 1
      end
  
      cont_nb_edit = to_128_inf(91) << str_sized(@liste[91]) << "\000"
  
  
      contt = ""
      contt << to_128(i) << contenu
  
      conttt = "Q"
      conttt << str_sized(contt) << cont_nb_edit

      cont << conttt

      #map_rm03 = RPG03::Map.new
      #map_rm03.contenu_fichier = cont

      return cont
  
    end


    def to_rmxp
      map = RPG::Map.new(@width, @height)

      map.tileset_id = @tileset_id
      map.autoplay_bgm = @autoplay_bgm
      map.bgm = @bgm
      map.autoplay_bgs = @autoplay_bgs
      map.bgs = @bgs
      map.encounter_list = @encounter_list
      map.encounter_step = @encounter_step
      map.data = @data


      map.events = {}
      for num, event in @events
        map.events[num] = event.to_rmxp
      end

      to_rmxp_dm(map)
      #p @dm
      return map
    end


    def to_rmxp_dm(map)
      if @dm.is_a?(Hash) == false
        @dm = {}
      end
      if @dm[$num] == nil
        hash = {$dmk_version => 1}
        @dm.update({$num => hash})
      else
        if @dm[$num].is_a?(Hash) == false
          @dm[$num] = {}
        end
        if @dm[$num][$dmk_version] == nil
          @dm[$num][$dmk_version] = 1
        end
        @dm[$num][$dmk_version] = @dm[$num][$dmk_version]+1
      end

      map.dm = @dm
      
    end

    def file_name(numero=nil)
      f_name = "Map%03d.dmk"
      if numero != nil
        return sprintf(f_name, numero)
      else
        return f_name
      end
    end



    def traiter_to_rmxp!
      changer_lignes!
    end
    

    def changer_lignes!
      for num, event in @events
        event.changer_lignes!
      end
    end



    # Pour faire la liste de toutes les instructions prsents dans une map
    def recuperer_code(codes)

      @total_instructions = 0

      # On cre la liste qui contiendra toutes les instructions
      liste_instr = []

      for event in self.events
        #p event[1]
        for page in event[1].pages
          # Pour compter le nombre total d'instructions parcourues
          @total_instructions += page.instructions.size
          for i in 0...page.instructions.size
            instruction = page.instructions[i]
            #p instruction
            # On passe  l'instruction suivante si on tombe sur un tableau
            next if instruction.is_a?(Array)
            #p instruction.class
            #puts "#{instruction.code} : #{hash_instr.has_key?(instruction.code)}"
            # On regarde si le code de l'instruction fait partie des codes recherchs
            next if codes.include?(instruction.code) == false
            liste_instr.push([self.numero, event[1].numero, page.numero, i, instruction])
          end
        end
      end

      return liste_instr


    end



    # Pour faire la liste de toutes les instructions prsents dans une map
    def recuperer_code_objet(codes)

      map_instr = nil
      
      for num_event, event in self.events
        event_instr = event.recuperer_code_objet(codes)
        if event_instr != nil
          if map_instr == nil
            # On cre la map qui contiendra les objets
            map_instr = Map_Instruction.new(self)
          end
          map_instr.add_event(event_instr)
        end
      end




      return map_instr


    end


    def total_instruction
      total = 0
      for num_event, event in self.events
        total += event.total_instruction
      end
      return total
    end


    
    def recuperer_ressource
      ressources = []
      
      if @autoplay_bgm == true and self.bgm.name != ""
        ressources << Instruction_Map.new(self, My_Ressource.new(self.bgm.name, D_BGM))
      end
      if @autoplay_bgs == true and self.bgs.name != ""
        ressources << Instruction_Map.new(self, My_Ressource.new(self.bgs.name, D_BGS))
      end

      
      for num_event, event in self.events
        ev_res = event.recuperer_ressource
        next if ev_res == nil
        ressources.concat(ev_res)
      end

      return ressources
    end


    

    def ecrire_dmk(projet)
      path = projet.path_dmk(file_name(@numero))
      return
      projet.ecrire_dmk(path, self)
    end


    def exporter_dialogue

      puts "Map #{@numero}".just(4)

      txt = ""
      for num_event, event in self.events.sort
        #p num_event
        txt << event.exporter_dialogue
      end

      return txt if txt == ""

      lignes = "\n"*2
      max = MAX_CARAC
      lignes << CARAC_MAP * max + "\n"
      lignes << "MAP #{@numero}" + "\n"
      lignes << CARAC_MAP * max + "\n"
      lignes << txt
      lignes << "\n"

      return lignes

    end


    def remplacer_texte(num_event, num_page, pos, message)

        event = self.events[num_event]
        if event == nil
          message.force_encoding("UTF-8")
          raise(DMKW_Message_Replace_Pos.new("[Map:#{@numero}:#{num_event}:#{num_page}:#{pos}]", message))
        end


      sembl = event.remplacer_texte(num_page, pos, message)


      return sembl
      
    end


    def name_rmxp
      return File.remplacer_extension(@name, "rxdata")
    end

    def name_dmk
      File.remplacer_extension(@name, "dmk")
    end




  end





  
end
